<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Incluir Bootstrap CSS -->
    <link href="<?php echo BASE_URL; ?>assets/css/bootstrap.min.css" rel="stylesheet">
    <!-- Incluir Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- Incluir Google Fonts para una tipografía moderna -->
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Incluir CSS personalizado -->
    <link href="<?php echo BASE_URL; ?>assets/css/custom.css" rel="stylesheet">
    <!-- Incluir Particles.js -->
    <script src="<?php echo BASE_URL; ?>assets/js/particles.min.js"></script>
    <!-- Incluir el script de configuración de partículas -->
    <script src="<?php echo BASE_URL; ?>assets/js/particles-config.js"></script>
</head>
<body>
    <div class="wrapper">
        <!-- Topbar -->
        <nav class="topbar">
            <!-- Fondo de partículas -->
            <div class="topbar-particles" id="topbar-particles"></div>
            <div class="topbar-content">
                <div class="topbar-brand">
                    <img src="<?php echo BASE_URL; ?>assets/images/sanidad-mask.png" alt="Sanidad Logo" class="topbar-logo">
                    <span>Sanidad</span>
                </div>
                <ul class="nav topbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo BASE_URL; ?>views/login/principal.php"><i class="fas fa-home me-2"></i> Inicio</a>
                    </li>
                    <?php
                    // Iniciar sesión si no está iniciada
                    if (session_status() === PHP_SESSION_NONE) {
                        session_start();
                    }
                    // Incluir la configuración para usar BASE_URL
                    require_once __DIR__ . '/../config/config.php';
                    ?>
                    <?php if (isset($_SESSION['role'])): ?>
                        <!-- Opciones comunes para todos los roles -->
                        <li class="nav-item">
                            <a class="nav-link" href="#"><i class="fas fa-user me-2"></i> Perfil</a>
                        </li>

                        <!-- Opciones para Superadmin, Administrador y RollPrimario -->
                        <?php if (in_array($_SESSION['role'], ['Superadmin', 'Administrador', 'RollPrimario'])): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="#"><i class="fas fa-calendar-check me-2"></i> Registro</a>
                            </li>
                        <?php endif; ?>

                        <!-- Opciones para Superadmin y Administrador -->
                        <?php if (in_array($_SESSION['role'], ['Superadmin', 'Administrador'])): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="#"><i class="fas fa-cog me-2"></i> Configuración</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#"><i class="fas fa-users me-2"></i> Usuarios</a>
                            </li>
                        <?php endif; ?>

                        <!-- Opciones exclusivas para Superadmin -->
                        <?php if ($_SESSION['role'] === 'Superadmin'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="#"><i class="fas fa-chart-line me-2"></i> Reportes</a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>

                    <!-- Enlace de Cerrar Sesión/Iniciar Sesión con ícono de carita -->
                    <li class="nav-item ms-auto session-link">
                        <?php if (isset($_SESSION['user_id'])): ?>
                            <a class="nav-link" href="<?php echo BASE_URL; ?>views/login/logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i> Cerrar Sesión
                                <i class="fas fa-user-circle ms-2"></i> <!-- Ícono de carita -->
                            </a>
                        <?php else: ?>
                            <a class="nav-link" href="<?php echo BASE_URL; ?>views/login/login.php">
                                <i class="fas fa-sign-in-alt me-2"></i> Iniciar Sesión
                                <i class="fas fa-user-circle ms-2"></i> <!-- Ícono de carita -->
                            </a>
                        <?php endif; ?>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Contenido principal -->
        <div class="main-content">