<?php
session_start();

// Incluir la configuración
require_once __DIR__ . '/../../config/config.php';

// Incluir el controlador
require_once __DIR__ . '/../../controllers/LoginController.php';

// Crear una instancia del controlador
$controller = new LoginController($pdo);

// Procesar el formulario de login si se envió
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["login"])) {
    if ($controller->login()) {
        header("Location: " . BASE_URL . "views/login/principal.php");
        exit();
    }
}

// Verificar si el usuario ya está logueado
if (isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "views/login/principal.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - Sistema de Seguridad</title>
    <!-- Incluir Bootstrap CSS -->
    <link href="<?php echo BASE_URL; ?>assets/css/bootstrap.min.css" rel="stylesheet">
    <!-- Incluir Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- Incluir CSS personalizado para el login -->
    <link href="<?php echo BASE_URL; ?>assets/css/login.css" rel="stylesheet">
    <!-- Incluir Google Fonts para una tipografía moderna -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- Fondo de partículas -->
    <div id="particles-js"></div>

    <!-- Logo inicial que aparece y se desvanece -->
    <div class="initial-logo">
        <img src="<?php echo BASE_URL; ?>assets/images/sanidad-mask.png" alt="Sanidad Logo">
    </div>

    <!-- Contenedor del login -->
    <div class="login-container">
        <!-- Logo o ícono -->
        <div class="login-logo">
            <img src="<?php echo BASE_URL; ?>assets/images/sanidad-mask.png" alt="Sanidad Logo">
        </div>
        <h2>Iniciar Sesión</h2>

        <!-- Mostrar mensaje de error si existe -->
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?>
            </div>
        <?php endif; ?>

        <!-- Mostrar mensaje de éxito si existe -->
        <?php if (isset($_GET['success'])): ?>
            <div class="alert alert-success" role="alert">
                <?php echo htmlspecialchars($_GET['success']); ?>
            </div>
        <?php endif; ?>

        <!-- Formulario de login -->
        <form class="login-form" action="<?php echo BASE_URL; ?>views/login/login.php" method="POST">
            <div class="form-group">
                <label for="username">Nombre de Usuario</label>
                <div class="input-wrapper">
                    <i class="fas fa-user input-icon"></i>
                    <input type="text" id="username" name="username" required>
                </div>
            </div>
            <div class="form-group">
                <label for="password">Contraseña</label>
                <div class="input-wrapper">
                    <i class="fas fa-lock input-icon"></i>
                    <input type="password" id="password" name="password" required>
                </div>
            </div>
            <button type="submit" name="login">Iniciar Sesión</button>
        </form>
    </div>

    <footer>
        <p>© <?php echo date('Y'); ?> Sistema de Seguridad. Todos los derechos reservados.</p>
    </footer>

    <!-- Incluir Particles.js -->
    <script src="<?php echo BASE_URL; ?>assets/js/particles.min.js"></script>
    <!-- Incluir Bootstrap JS -->
    <script src="<?php echo BASE_URL; ?>assets/js/bootstrap.bundle.min.js"></script>
    <!-- Configuración de Particles.js -->
    <script>
        particlesJS("particles-js", {
            "particles": {
                "number": {
                    "value": 40, /* Menos partículas para mayor claridad */
                    "density": {
                        "enable": true,
                        "value_area": 800
                    }
                },
                "color": {
                    "value": "#ffffff" /* Partículas blancas puras */
                },
                "shape": {
                    "type": "circle",
                    "stroke": {
                        "width": 0,
                        "color": "#000000"
                    }
                },
                "opacity": {
                    "value": 0.9, /* Mayor opacidad para más claridad */
                    "random": false,
                    "anim": {
                        "enable": false,
                        "speed": 1,
                        "opacity_min": 0.5,
                        "sync": false
                    }
                },
                "size": {
                    "value": 4, /* Tamaño más grande para mayor visibilidad */
                    "random": true,
                    "anim": {
                        "enable": false,
                        "speed": 40,
                        "size_min": 0.1,
                        "sync": false
                    }
                },
                "line_linked": {
                    "enable": true,
                    "distance": 120, /* Líneas un poco más largas */
                    "color": "#e0e0e0", /* Líneas gris más claro */
                    "opacity": 0.8, /* Mayor opacidad para líneas */
                    "width": 1.2 /* Líneas ligeramente más gruesas */
                },
                "move": {
                    "enable": true,
                    "speed": 1.5, /* Velocidad más lenta para un efecto elegante */
                    "direction": "none",
                    "random": false,
                    "straight": false,
                    "out_mode": "out",
                    "bounce": false
                }
            },
            "interactivity": {
                "detect_on": "canvas",
                "events": {
                    "onhover": {
                        "enable": true,
                        "mode": "repulse"
                    },
                    "onclick": {
                        "enable": true,
                        "mode": "push"
                    },
                    "resize": true
                },
                "modes": {
                    "grab": {
                        "distance": 400,
                        "line_linked": {
                            "opacity": 1
                        }
                    },
                    "bubble": {
                        "distance": 400,
                        "size": 40,
                        "duration": 2,
                        "opacity": 8,
                        "speed": 3
                    },
                    "repulse": {
                        "distance": 100,
                        "duration": 0.4
                    },
                    "push": {
                        "particles_nb": 4
                    },
                    "remove": {
                        "particles_nb": 2
                    }
                }
            },
            "retina_detect": true
        });

        // Animación para el logo inicial y el contenedor
        window.onload = function() {
            const initialLogo = document.querySelector('.initial-logo');
            const loginContainer = document.querySelector('.login-container');
            setTimeout(() => {
                initialLogo.style.opacity = '0'; /* Desvanece el logo después de 2 segundos */
            }, 500);
            setTimeout(() => {
                loginContainer.style.opacity = '1'; /* Muestra el contenedor después de 3 segundos */
            }, 1000);
        };
    </script>
</body>
</html>