<?php
require_once __DIR__ . '/../models/UserModel.php';

class LoginController {
    private $userModel;

    // Lista estática de nombres de PCs permitidas
    private $allowedPCs = [
        'PC-ALLOWED-1',
        'PC-ALLOWED-2',
        'DESKTOP-VPBBRNP', // Ejemplo: nombres de PCs permitidas
        'WORKSTATION-001'
    ];

    public function __construct($pdo) {
        $this->userModel = new UserModel($pdo);
    }

    public function login() {
        if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["login"])) {
            $username = trim($_POST["username"]);
            $password = trim($_POST["password"]);
            // Obtener el nombre de la PC desde el formulario o el servidor
            $pcName = trim($_POST["pc_name"] ?? gethostbyaddr($_SERVER['REMOTE_ADDR']) ?? 'unknown');

            // Validar campos obligatorios
            if (empty($username) || empty($password)) {
                $_SESSION['error'] = "El nombre de usuario y la contraseña son obligatorios.";
                return false;
            }

            // Validar nombre de la PC
            if ($pcName === 'unknown' || !in_array($pcName, $this->allowedPCs)) {
                $_SESSION['error'] = "Acceso denegado: PC no autorizada.";
                return false;
            }

            // Buscar el usuario
            $user = $this->userModel->findUserByUsername($username);

            if ($user && password_verify($password, $user['password'])) {
                // Iniciar sesión
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['role'] = $user['role'];
                $_SESSION['pc_name'] = $pcName; // Opcional: almacenar el nombre de la PC en la sesión
                return true;
            } else {
                $_SESSION['error'] = "Nombre de usuario o contraseña incorrectos.";
                return false;
            }
        }
        return false;
    }

    public function checkAuth() {
        if (!isset($_SESSION['user_id']) || !isset($_SESSION['username']) || !isset($_SESSION['role'])) {
            $_SESSION['error'] = "Por favor, inicia sesión para acceder a esta página.";
            header("Location: " . BASE_URL . "views/login/login.php");
            exit();
        }
    }

    public function logout() {
        session_unset();
        session_destroy();
        header("Location: " . BASE_URL . "views/login/login.php?success=Sesión cerrada correctamente.");
        exit();
    }
}
?>